<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>StepOut Login - Total Management System</title>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

    <style>
        body, html {
            height: 100%;
            margin: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: white;
        }

        .bg-container {
            background: linear-gradient(rgba(0,0,0,.4), rgba(0,0,0,.4)),
                        url('{{ asset("img/bg-first.png") }}') no-repeat center center fixed;
            background-size: cover;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
        }

        .brand-logo {
            position: absolute;
            top: 30px;
            left: 30px;
        }

        .login-card {
            background: rgba(16, 26, 43, 0.85);
            backdrop-filter: blur(10px);
            border-radius: 15px;
            padding: 40px;
            width: 100%;
            max-width: 450px;
            box-shadow: 0 8px 32px rgba(0,0,0,.8);
            border: 1px solid rgba(255,255,255,.1);
        }

        .form-control {
            background: transparent;
            border: none;
            color: white;
        }

        .form-control:focus {
            background: transparent;
            color: white;
            box-shadow: none;
        }

        .input-group {
            background: rgba(255,255,255,.05);
            border: 1px solid rgba(255,255,255,.2);
            border-radius: 8px;
        }

        .input-group-text {
            background: transparent;
            border: none;
            color: #888;
        }

        .btn-login {
            background: linear-gradient(90deg,#2b3a55,#3b4d70);
            border: none;
            color: white;
            padding: 12px;
            width: 100%;
            border-radius: 8px;
            font-weight: bold;
            text-transform: uppercase;
            margin-top: 20px;
        }

        .error-msg {
            background: rgba(255,0,0,.2);
            color: #ff8080;
            border-radius: 5px;
            padding: 10px;
            font-size: 14px;
            margin-bottom: 15px;
            border: 1px solid rgba(255,0,0,.3);
        }
    </style>
</head>
<body>

<div class="bg-container">

    <div class="brand-logo">
        <h4 class="mb-0"><i class="fas fa-link"></i> StepOut</h4>
        <small>Live The Game</small>
    </div>

    <div class="login-card text-center">

        <div class="mb-3">
            <i class="fas fa-link fa-2x"></i>
        </div>

        <h2>Total Management System</h2>
        <p>Login to manage your account</p>

        {{-- Validation Errors --}}
        @if ($errors->any())
            <div class="error-msg">
                {{ $errors->first() }}
            </div>
        @endif

        <form method="POST" action="{{ route('login') }}" class="text-left mt-4">
            @csrf

            <div class="form-group">
                <label>Email</label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text"><i class="fas fa-user"></i></span>
                    </div>
                    <input type="email" name="email" class="form-control"
                           placeholder="Enter Email" required autofocus>
                </div>
            </div>

            <div class="form-group">
                <label>Password</label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text"><i class="fas fa-lock"></i></span>
                    </div>
                    <input type="password" name="password" id="password"
                           class="form-control" placeholder="••••••••" required>

                    <div class="input-group-append" onclick="togglePassword()" style="cursor:pointer;">
                        <span class="input-group-text">
                            <i class="fas fa-eye" id="eyeIcon"></i>
                        </span>
                    </div>
                </div>
            </div>

            <div class="custom-control custom-checkbox mt-3">
                <input type="checkbox" name="remember" class="custom-control-input" id="rememberMe">
                <label class="custom-control-label" for="rememberMe">
                    Remember me
                </label>
            </div>

            <button type="submit" class="btn btn-login">Login</button>

            <div class="text-center mt-3">
                <a href="{{ route('register') }}" class="text-white">
                    Don't have account? Register
                </a>
            </div>

        </form>
    </div>
</div>

<script>
function togglePassword(){
    const pass = document.getElementById('password');
    const icon = document.getElementById('eyeIcon');
    if(pass.type === "password"){
        pass.type = "text";
        icon.classList.replace('fa-eye','fa-eye-slash');
    }else{
        pass.type = "password";
        icon.classList.replace('fa-eye-slash','fa-eye');
    }
}
</script>

</body>
</html>